﻿using System;
using Sitecore.Globalization;
using Sitecore.StringExtensions;

namespace Smartling.Connector.sitecore_modules.Shell.Smartling.Connector
{
  public partial class PreviewTranslation : System.Web.UI.Page
  {
    private const string FrameFormatString = "http://{0}/?sc_itemid={1}&sc_lang={2}&sc_mode=preview";

    protected void Page_Load(object sender, EventArgs e)
    {
      var leftFrame = FrameFormatString.FormatWith(Request.Url.Host, Request["lid"], Request["llang"]);
      var rightFrame = FrameFormatString.FormatWith(Request.Url.Host, Request["rid"], Request["rlang"]);

      Left.Text = "<iframe class=\"left\" style=\"width: 100%;\" src=\"{0}\"></iframe>".FormatWith(leftFrame);
      Right.Text = "<iframe class=\"right\" style=\"width: 100%;\" src=\"{0}\"></iframe>".FormatWith(rightFrame);
      TargetLanguage.Text = Language.Parse(Request["rlang"]).CultureInfo.DisplayName;
    }
  }
}